CREATE TABLE eye.verified_detection_location (
    id bigserial PRIMARY KEY,
    source eye.verification_source NOT NULL,
    txn_id bigint NOT NULL,
    detection_id bigint NOT NULL REFERENCES eye.detection (detection_id) ON DELETE CASCADE,
    position geometry(point, 3395),
    rotation real[4],

    UNIQUE(source, detection_id)
);

CREATE INDEX eye_verified_detection_location_txn_id_index ON eye.verified_detection_location USING btree(txn_id);
CREATE INDEX eye_verified_detection_location_detection_id_index ON eye.verified_detection_location USING btree(detection_id);
CREATE INDEX eye_verified_detection_location_position_is_null_index ON eye.verified_detection_location ((TRUE)) WHERE position IS NULL;
