CREATE TYPE signals.disq_type AS ENUM (
    'disable_capturing',
    'disable_publishing'
);

CREATE TABLE signals.disqualified_source (
    id bigserial PRIMARY KEY,
    disq_type signals.disq_type NOT NULL,
    source_id text NOT NULL,
    started_at timestamp with time zone NOT NULL,
    ended_at timestamp with time zone,

    CONSTRAINT time_check CHECK (
        started_at <= ended_at OR ended_at IS NULL
    )
);

CREATE INDEX disqualified_source_source_id_ended_at_index
    ON signals.disqualified_source (source_id, ended_at DESC);
    
CREATE UNIQUE INDEX disqualified_source_source_id_disq_type_index
    ON signals.disqualified_source (source_id, disq_type)
    WHERE ended_at IS NULL;
