DROP INDEX IF EXISTS eye_verified_detection_missing_on_frame_detection_is_visible_is_null_index;

ALTER TABLE eye.verified_detection_missing_on_frame DROP COLUMN place_is_visible;
ALTER TABLE eye.verified_detection_missing_on_frame DROP COLUMN detection_is_hidden;
ALTER TABLE eye.verified_detection_missing_on_frame DROP COLUMN detection_is_visible;

CREATE TYPE eye.verified_detection_missing_on_frame_answer AS ENUM (
    'yes',
    'no',
    'unknown'
);

ALTER TABLE eye.verified_detection_missing_on_frame ADD COLUMN place_is_visible eye.verified_detection_missing_on_frame_answer;
ALTER TABLE eye.verified_detection_missing_on_frame ADD COLUMN detection_is_hidden eye.verified_detection_missing_on_frame_answer;
ALTER TABLE eye.verified_detection_missing_on_frame ADD COLUMN detection_is_visible eye.verified_detection_missing_on_frame_answer;

CREATE INDEX eye_verified_detection_missing_on_frame_detection_is_visible_is_null_index ON eye.verified_detection_missing_on_frame USING btree(detection_is_visible) WHERE detection_is_visible IS NULL;
