#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/wikimap/mapspro/services/mrc/onfoot-processor/lib/worker.h>

using namespace maps::mrc;

int main(int argc, char* argv[])
try {
    maps::cmdline::Parser parser;
    auto configPath = parser
        .file("config")
        .help("path to configuration");

    auto syslog = parser
        .string("syslog-tag")
        .help("redirect log output to syslog with given tag");

    auto dryRun = parser
        .flag("dry-run")
        .help("Do not commit to DB and not send feedback to social");

    parser.parse(argc, argv);

    if (syslog.defined()) {
        maps::log8::setBackend(maps::log8::toSyslog(syslog));
    }

    if (dryRun.defined()) {
        INFO() << "Dry run is on";
    }

    auto cfg = common::templateConfigFromCmdPath(configPath);
    auto poolHolder = cfg.makePoolHolder(maps::mrc::common::LONG_READ_DB_ID,
                                         maps::mrc::common::LONG_READ_POOL_ID);

    onfoot::Worker worker(
        cfg,
        poolHolder.pool(),
        dryRun.defined()
            ? onfoot::DryRun::Yes
            : onfoot::DryRun::No);

    worker.initTvmClient(maps::auth::TvmtoolSettings().selectClientAlias("maps-core-nmaps-mrc-onfoot-processor"));

    worker.run();

    return EXIT_SUCCESS;
} catch (const maps::Exception& e) {
    ERROR() << e;
    return EXIT_FAILURE;
} catch (const std::exception& e) {
    ERROR() << e.what();
    return EXIT_FAILURE;
}
