#include "utils.h"

#include <maps/libs/common/include/exception.h>

namespace maps::mrc::onfoot {

std::string humanReadableFeedbackType(db::WalkFeedbackType type)
{
    switch (type) {
        case db::WalkFeedbackType::Barrier:
            return "Барьер/Ворота";
        case db::WalkFeedbackType::BuildingEntrance:
        case db::WalkFeedbackType::EntrancePlate:
            return "Подъезд/Вход";
        case db::WalkFeedbackType::AddressPlate:
            return "Адресная табличка";
        case db::WalkFeedbackType::BusinessSign:
            return "Вывеска организации";
        case db::WalkFeedbackType::BusinessWorkingHours:
            return "Время работы";
        case db::WalkFeedbackType::FootPath:
            return "Пешеходная дорожка";
        case db::WalkFeedbackType::CyclePath:
            return "Велосипедная дорожка";
        case db::WalkFeedbackType::Stairs:
            return "Лестница/Пандус";
        case db::WalkFeedbackType::Ramp:
            return "Пандус";
        case db::WalkFeedbackType::Room:
            return "Помещение";
        case db::WalkFeedbackType::Wall:
            return "Стена";
        case db::WalkFeedbackType::Organization:
            return "Организация";
        case db::WalkFeedbackType::Fence:
            return "Забор";
        case db::WalkFeedbackType::Building:
            return "Здание/Фасад";
        case db::WalkFeedbackType::Parking:
            return "Парковка";
        case db::WalkFeedbackType::None:
        case db::WalkFeedbackType::Other:
            return {};
        default:
            REQUIRE(false, "Failed to make feedback type " << type << " readable");
    }
}

} // namespace maps::mrc::onfoot
