#pragma once

#include <maps/libs/auth/include/tvm.h>
#include <maps/libs/http/include/http.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/walk_object.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>

#include <memory>
#include <string>

namespace maps::mrc::onfoot {

enum class DryRun { Yes, No };

class Worker
{
public:
    Worker(
        common::Config cfg,
        pgpool3::Pool& pool,
        DryRun dryRun
    )
        : cfg_(std::move(cfg))
        , pool_(pool)
        , dryRun_(dryRun)
    {}

    /**
     * Reads a bunch of objects in the pending state and processes them
     * @return true if there is at least one pending object
     */
    bool runOnce(pqxx::transaction_base& lockTxn);

    void run();

    void initTvmClient(const auth::TvmtoolSettings& tvmToolSettings);

private:
    std::string makeRequestBody(
        db::WalkObjects::iterator first,
        db::WalkObjects::iterator last,
        const db::Features& walkPhotos,
        std::string_view feedbackSource);
    void sendToSocial(
        db::WalkObjects::iterator first,
        db::WalkObjects::iterator last,
        const db::Features& walkPhotos,
        std::string_view feedbackSource);

    void processWalkObjectGroup(db::WalkObjects::iterator first,
                                db::WalkObjects::iterator last);

    common::Config cfg_;
    pgpool3::Pool& pool_;
    http::Client client_;
    DryRun dryRun_;
    std::unique_ptr<NTvmAuth::TTvmClient> tvmClient_;
};

} // namespace maps::mrc::onfoot
