#pragma once

#include <mapreduce/yt/interface/client.h>
#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/common.h>

namespace maps::mrc::image_analyzer {

class FeatureImageMapper : public yt::Mapper
{
public:
    FeatureImageMapper() = default;

    FeatureImageMapper(const TString& config, bool enableForbiddenClassifier);

    Y_SAVELOAD_JOB(config_, enableForbiddenClassifier_);

    void Do(TReader* reader, TWriter* writer) override;

private:
    TString config_;
    bool enableForbiddenClassifier_;
};

class YavisionMapper : public yt::Mapper
{
public:
    YavisionMapper() = default;

    YavisionMapper(const TString& config);

    Y_SAVELOAD_JOB(config_);

    void Do(TReader* reader, TWriter* writer) override;

private:
    TString config_;
};

} // namespace maps::mrc::image_analyzer
