#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/object_in_photo.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>

#include <unordered_map>

namespace maps::mrc::image_analyzer {

enum class UseGpu { Yes, No };

struct ProcessedFeature {
    db::Feature feature;
    db::ObjectsInPhoto privacyObjects;
};

using ProcessedFeatureById = std::unordered_map<db::TId, ProcessedFeature>;

/**
 * Executes following classification/detection tasks on YT for every feature:
 *  - image quality classification
 *  - forbidden content detection
 *  - road probability classification
 *  - privacy objects detection
 */
ProcessedFeatureById processOnYT(
    const db::Features& features,
    const common::Config& mrcConfig,
    UseGpu useGpu);

} // maps::mrc::image_analyzer
