#include <maps/infra/yacare/include/tvm.h>
#include <maps/infra/yacare/include/yacare.h>
#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/mongo/include/init.h>
#include <maps/tools/grinder/common/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/graph_matcher_adapter/include/matcher.h>
#include <maps/wikimap/mapspro/services/mrc/tasks-planner/lib/globals.h>

const yacare::VirtualHost VHOST{
    yacare::VirtualHost::SLB {
        "core-nmaps-mrc-tasksplanner",
    },
    yacare::VirtualHost::FQDN {
        "core-nmaps-mrc-tasksplanner.unstable.maps.n.yandex.ru",
        "core-nmaps-mrc-tasksplanner.testing.maps.n.yandex.ru",
        "core-nmaps-mrc-tasksplanner.crowdtest.maps.yandex-team.ru",
        "core-nmaps-mrc-tasksplanner.crowdtest.maps.yandex.ru"
    },
};

// Service accesses to external database to process requests
static yacare::ThreadPool heavyPool("heavy", yacare::ThreadPool::CPUCOUNT * 10, 4096);

YCR_SET_DEFAULT(VHOST, heavyPool);


YCR_MAIN(argc, argv) try {
    using namespace maps::mrc::tasks_planner;

    maps::cmdline::Parser parser;

    auto configPath = parser.string("config")
        .help("path to configuration");

    auto grinderConfigPath = parser.string("grinder-config")
        .help("path to grinder configuration");

    auto secretVersion = parser.string("secret-version")
        .help("version for secrets from yav.yandex-team.ru");

    auto graphFolder = parser.string("graph-dir")
            .defaultValue(maps::mrc::adapters::GRAPH_FOLDER)
            .help("directory graph data is loaded from");

    auto pedestrianGraphFolder = parser.string("pedestrian-graph-dir")
            .defaultValue("/var/lib/yandex/maps/ecstatic/data/yandex-maps-mrc-pedestrian-graph-pro")
            .help("directory pedestrian graph data is loaded from");

    parser.parse(argc, argv);

    maps::mongo::init();

    const auto config =
        maps::mrc::common::templateConfigFromCmdPath(secretVersion, configPath);

    auto grinderConfig = grinderConfigPath.defined()
                             ? maps::grinder::Config{grinderConfigPath}
                             : maps::grinder::Config{};

    yacare::tvm::configureUserAuth(
        maps::auth::BlackboxApi(maps::auth::TvmtoolSettings()));

    Globals::useConfigs(std::move(config),
                        std::move(grinderConfig),
                        graphFolder,
                        pedestrianGraphFolder);

    yacare::run();

    return EXIT_SUCCESS;
} catch (const maps::Exception& e) {
    std::cerr << e;
    return EXIT_FAILURE;
} catch (const std::exception& e) {
    std::cerr << e.what();
    return EXIT_FAILURE;
}
