#include "common.h"

#include <maps/libs/json/include/exception.h>

namespace maps {
namespace mrc {
namespace tasks_planner {

AssignmentReviewsMap
loadAssignmentsReviewsMap(pqxx::transaction_base& txn, const db::TIds& assignmenIds)
{
    db::ugc::AssignmentReviewGateway gtw(txn);
    auto reviews = gtw.load(db::ugc::table::AssignmentReview::assignmentId.in(assignmenIds));

    AssignmentReviewsMap result;
    for(auto& review : reviews) {
        db::TId assignmentId = review.assignmentId();
        result[assignmentId].push_back(std::move(review));
    }
    return result;
}

TasksGroupEmailsMap
loadTasksGroupEmailsMap(pqxx::transaction_base& txn, const db::TIds& tasksGroupIds)
{
    auto result = TasksGroupEmailsMap{};
    auto tasksGroupEmails = db::ugc::TasksGroupEmailGateway{txn}.load(
        db::ugc::table::TasksGroupEmail::tasksGroupId.in(tasksGroupIds));
    for (auto& tasksGroupEmail : tasksGroupEmails) {
        auto tasksGroupId = tasksGroupEmail.tasksGroupId();
        result[tasksGroupId].push_back(std::move(tasksGroupEmail));
    }
    return result;
}

TasksGroupKit
loadTasksGroupKit(pqxx::transaction_base& txn, db::TId tasksGroupId)
{
    return TasksGroupKit{
        .obj = loadByIdElse404(db::ugc::TasksGroupGateway{txn}, tasksGroupId),
        .emails = db::ugc::TasksGroupEmailGateway{txn}.load(
            db::ugc::table::TasksGroupEmail::tasksGroupId == tasksGroupId)};
}

void setTasksGroupId(db::TId tasksGroupId, db::ugc::TasksGroupEmails& result)
{
    for (auto& item : result) {
        item = db::ugc::TasksGroupEmail{tasksGroupId, item.email()};
    }
}

bool shouldReverseOrder(const yacare::Request& request)
{
    const std::string& SORT_PARAM = "sort";
    if (request.input().has(SORT_PARAM) &&
            request.input()[SORT_PARAM] == "desc")
    {
        return true;
    }
    return false;
}

json::Value parseJsonFromRequestBodyElse400(const yacare::Request& request)
{
    try {
        return json::Value::fromString(request.body());
    } catch (const json::ParserError& error) {
        throw yacare::errors::BadRequest()
            << "Expecting request body to be json: " << error.what();
    }
}

void setTotalCountHeader(yacare::Response& response, size_t count) {
    response.setHeader("X-Total-Count", std::to_string(count));
}

std::optional<chrono::TimePoint>
parseOptionalDateParam(const yacare::Request& request, const std::string& param)
{
    if (!request.input().has(param)) {
        return {};
    }

    try {
        return chrono::parseIsoDateTime(request.input()[param]);
    } catch (const std::exception& ex) {
        WARN() << "Failed to parse '" << param << "' param value: "
            <<  request.input()[param] << "' " << ex.what();
        throw yacare::errors::BadRequest() << param
            << " param value is invalid";
    }
}

} // namespace tasks_planner
} // namespace mrc
} // namespace maps
