#pragma once

#include <maps/libs/auth/include/tvm.h>
#include <maps/wikimap/mapspro/services/mrc/libs/blackbox_client/include/blackbox_client.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/graph_matcher_adapter/include/compact_graph_matcher_adapter.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>
#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/tools/grinder/common/include/client.h>
#include <yandex/maps/mds/mds.h>

#include <memory>

namespace maps {
namespace mrc {
namespace tasks_planner {

// @see https://abc.yandex-team.ru/services/passport-frontend/resources/
static const auth::TvmId PASSPORT_FRONTEND_TVM_ID_STABLE = 2010646;
static const auth::TvmId PASSPORT_FRONTEND_TVM_ID_TESTING = 2010644;

using IBlackboxClientHolder
    = std::unique_ptr<blackbox_client::IBlackboxClient>;

class Globals {
public:
    static void useConfigs(
        common::Config,
        grinder::Config,
        const std::string& roadGraphFolder,
        const std::string& pedestrianGraphFolder,
        const auth::TvmtoolSettings& = auth::TvmtoolSettings());

    static const common::Config& config();
    static pgpool3::Pool& pool();
    static grinder::Client& grinderClient();
    static mds::Mds& mds();
    static blackbox_client::IBlackboxClient& blackbox();
    static const std::vector<auth::TvmId>& passportFrontendTvmIds();
    static adapters::CompactGraphMatcherAdapter& roadMatcher();
    static adapters::CompactGraphMatcherAdapter& pedestrianMatcher();

    static IBlackboxClientHolder swap(IBlackboxClientHolder);

private:
    struct Data {
        Data(mrc::common::Config,
             grinder::Config config,
             const std::string& roadGraphFolder,
             const std::string& pedestrianGraphFolder,
             const auth::TvmtoolSettings&);

        mrc::common::Config config;
        wiki::common::PoolHolder poolHolder;
        grinder::MongoTaskLogger grinderLogger;
        grinder::Client grinderClient;
        mds::Mds mds;
        IBlackboxClientHolder blackbox;
        std::vector<auth::TvmId> passportFrontendTvmIds;
        adapters::CompactGraphMatcherAdapter roadMatcher;
        adapters::CompactGraphMatcherAdapter pedestrianMatcher;
    };

private:
    Globals() = default;
    static Globals& instance();

    std::unique_ptr<Data> data_;
};


} // namespace tasks_planner
} // namespace mrc
} // namespace maps
