#include "make_visualization.h"

#include <maps/libs/geolib/include/conversion.h>

#include <math.h>

namespace maps::mrc::tasks_planner {

geolib3::PolylinesVector
makeVisualizationPolylines(const db::ugc::Targets& targets)
{
    geolib3::PolylinesVector visualizedTargets;
    for (const auto& target : targets) {
        auto polylines = makeVisualizationPolylines(target);
        visualizedTargets.insert(visualizedTargets.end(),
                                 std::make_move_iterator(polylines.begin()),
                                 std::make_move_iterator(polylines.end()));
    }
    return visualizedTargets;
}

geolib3::PolylinesVector
makeVisualizationPolylines(const db::ugc::Target& target)
{
    constexpr double RIDE_SIDE_SHIFT_METERS = 10.;
    const auto latitude = geolib3::Degrees(target.geodeticGeom().pointAt(0).y());
    const double mercatorScale = 1 / std::cos(geolib3::toRadians(latitude).value());
    const double scaledRideSideShiftMeters = RIDE_SIDE_SHIFT_METERS * mercatorScale;

    geolib3::PolylinesVector result;

    auto mercatorGeom = geolib3::convertGeodeticToMercator(target.geodeticGeom());
    const geolib3::Orientation equidistanceOrientation =
        target.traffic() == db::ugc::Traffic::RightHand ? geolib3::Clockwise : geolib3::Counterclockwise;

    if (target.direction() == db::ugc::Direction::Bidirectional ||
            target.direction() == db::ugc::Direction::Forward)
    {
        result.push_back(
            geolib3::convertMercatorToGeodetic(
                geolib3::equidistant(mercatorGeom, scaledRideSideShiftMeters, equidistanceOrientation)
            )
        );
    }

    if (target.direction() == db::ugc::Direction::Bidirectional ||
            target.direction() == db::ugc::Direction::Backward)
    {
        result.push_back(
            geolib3::convertMercatorToGeodetic(
                geolib3::equidistant(mercatorGeom, scaledRideSideShiftMeters,
                                 geolib3::reverse(equidistanceOrientation))
            )
        );
    }
    return result;
}

} // namespace maps::mrc::tasks_planner

