#pragma once

#include "common.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/object_in_photo_gateway.h>

#include <maps/libs/json/include/builder.h>

#include <locale>
#include <unordered_map>

namespace maps {
namespace mrc {
namespace tasks_planner {


template<typename ObjectStatus>
ObjectStatus fromString(const std::string& value);

std::string toString(db::ugc::TasksGroupStatus status);

template<>
db::ugc::TasksGroupStatus fromString(const std::string& value);

std::string toString(db::ugc::TaskStatus status);

template<>
db::ugc::TaskStatus fromString(const std::string& value);


std::string toString(db::ugc::AssignmentStatus status);

template<>
db::ugc::AssignmentStatus fromString(const std::string& value);


std::string toString(db::CameraDeviation status);

template<>
db::CameraDeviation fromString(const std::string& value);

template<>
db::FeaturePrivacy fromString(const std::string&);

std::string toString(db::FeaturePrivacy);

template<>
db::ObjectInPhotoType fromString(const std::string& value);


void toJson(json::ObjectBuilder& builder,
            const TasksGroupKit&,
            const TaskStatusesMap& tasksStatuses,
            const maps::Locale& locale);

std::string toString(db::ugc::TasksGroupStatus status);
void fromString(const std::string& value, db::ugc::TasksGroupStatus& status);

TasksGroupKit createTasksGroup(const json::Value&);
void patchByJson(TasksGroupKit&, const json::Value&);


void toJson(json::ObjectBuilder obj,
            const db::ugc::Task& task,
            const std::optional<db::ugc::Assignment>& assignment,
            const db::ugc::AssignmentReviews& review,
            const maps::Locale& locale);

void toJson(json::ObjectBuilder obj,
            const db::ugc::Assignment& asgnmt,
            const db::ugc::AssignmentReviews& review,
            const maps::Locale& locale);

void toJson(json::ObjectBuilder obj,
            const db::ugc::AssignmentReview& review,
            const maps::Locale& locale);

void toJson(json::ObjectBuilder obj, const std::string& baseUrl, const db::Feature& photo);

void toJson(json::ObjectBuilder obj, const db::ugc::AssignmentObject& aobj);

void toJson(json::ObjectBuilder builder, const db::Feature& photo, const db::ObjectInPhoto& obj);

inline auto asGeojsonPosition(const geolib3::Point2& point) {
    return [&](json::ArrayBuilder arr) {
        arr << point.x() << point.y();
    };
}

db::ObjectInPhoto createObjectInPhoto(const db::Feature& photo,
                                      const json::Value& value);

} // namespace tasks_planner
} // namespace mrc
} // namespace maps
