#pragma once
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>
#include <maps/libs/introspection/include/comparison.h>
#include <maps/libs/pgpool/include/pgpool3.h>

#include <map>
#include <string>

namespace maps {
namespace mrc {
namespace tasks_planner {
namespace tests {

using introspection::operator<;

const Locale RUSSIAN = boost::lexical_cast<Locale>("ru");

std::string schemasDir();

std::string schemasPath();

struct Response {
    std::string method;
    std::string path;
    int status;
};

inline auto introspect(const Response& t)
{
    return std::tie(t.method, t.path, t.status);
}

std::map<Response, std::string>
readResponseSchemasFromSwagger(const std::string& path);

void validateJson(const std::string& jsonStr,
                  const std::string& schema,
                  const std::string& schemaDir);

} // namespace tests
} // namespace tasks_planner
} // namespace mrc
} // namespace maps
