exports.Task = extend(TolokaHandlebarsTask, function (options) {
  this._inputs = options.task.input_values;
  TolokaHandlebarsTask.call(this, options);
}, {
  validate: function (solution) {
    var output = solution.output_values;
    if (!output.is_visible) {
      return {
        task_id: this.getTask().id,
          errors: {
            is_visible: {
              code: 'NOT_ALLOWED',
              message: 'Необходимо выбрать один из вариантов!'
            }
          }
      };
    }

    if (output.is_visible == "no") {
      if (!output.missing_reason) {
        return {
          task_id: this.getTask().id,
          errors: {
            missing_reason: {
              code: 'NOT_ALLOWED',
              message: 'Необходимо выбрать один из вариантов!'
            }
          }
        };
      }
    }

    return null;
  },
  onRender: function() {    
    function draw(canvas, url, bbox = null) {
      var image = new Image();
      image.src = url
      image.addEventListener('load', function () {
        canvas[0].width = image.width;
        canvas[0].height = image.height;
        var context = canvas[0].getContext('2d');
        context.drawImage(image, 0, 0);

        if (bbox == null) {
          return;
        }

        var x1 = Math.min(bbox[0][0], bbox[1][0])
        var y1 = Math.min(bbox[0][1], bbox[1][1])
        var x2 = Math.max(bbox[0][0], bbox[1][0])
        var y2 = Math.max(bbox[0][1], bbox[1][1])

        var width = x2 - x1
        var height = y2 - y1

        var x_pad = Math.max(10, Math.round(width * 0.15))
        var y_pad = Math.max(10, Math.round(height * 0.15))
        x1 = Math.max(0, x1 - x_pad)
        y1 = Math.max(0, y1 - y_pad)
        x2 = Math.min(image.width, x2 + x_pad)
        y2 = Math.min(image.height, y2 + y_pad)

        width = x2 - x1
        height = y2 - y1

        context.beginPath();
        context.lineWidth = '5';
        context.strokeStyle= 'red';
        context.rect(x1, y1, width, height);
        context.closePath();
        context.stroke();

        context.beginPath();
        context.lineWidth = '5';
        context.strokeStyle= 'yellow';
        context.rect(x1 - 5, y1 - 5, width + 5 * 2, height + 5 * 2);
        context.closePath();
        context.stroke();

        context.beginPath();
        context.strokeStyle= 'blue';
        context.arc(x1, y1, 10, 0, 2 * Math.PI);
        context.closePath();
        context.fillStyle = 'white';
        context.fill();
        context.stroke();

        context.beginPath();
        context.strokeStyle= 'blue';
        context.arc(x1, y2, 10, 0, 2 * Math.PI);
        context.closePath();
        context.fillStyle = 'white';
        context.fill();
        context.stroke();

        context.beginPath();
        context.strokeStyle= 'blue';
        context.arc(x2, y1, 10, 0, 2 * Math.PI);
        context.closePath();
        context.fillStyle = 'white';
        context.fill();
        context.stroke();

        context.beginPath();
        context.strokeStyle= 'blue';
        context.arc(x2, y2, 10, 0, 2 * Math.PI);
        context.closePath();
        context.fillStyle = 'white';
        context.fill();
        context.stroke();
      });
    }

    var left = $(this.getDOMElement()).find('.left');
    var left_canvas = left[0].getElementsByTagName('canvas');
    draw(left_canvas, this._inputs.image1, this._inputs.bbox1);

    left[0].onclick = function () {
      if (left[0].className == "left image") {
        left[0].className = "left image image_zoom";
      } else {
        left[0].className = "left image";
      }
    }

    var right = $(this.getDOMElement()).find('.right');
    var right_canvas = right[0].getElementsByTagName('canvas');
    draw(right_canvas, this._inputs.image2);

    right[0].onclick = function () {
      if (right[0].className == "right image") {
        right[0].className = "right image image_zoom";
      } else {
        right[0].className = "right image";
      }
    }

    var missing_reason_attributes = $(this.getDOMElement()).find('.missing_reason')[0];
    var showMissingReasonAttributes = function() {
      missing_reason_attributes.style.display = 'block'
    }
    var hideMissingReasonAttributes = function() {
      missing_reason_attributes.style.display = 'none'
    } 

    var output_values = this.getSolution().output_values
    if (output_values.is_visible) {
      if (output_values.is_visible == 'no') {
        showMissingReasonAttributes();
      } else {
        hideMissingReasonAttributes();
      }
    }
      
    var radios = $(this.getDOMElement()).find('.field_type_radio');

    var yesIsVisibleRadio = radios[0];
    yesIsVisibleRadio.onclick = hideMissingReasonAttributes
    var noIsVisibleRadio = radios[1];
    noIsVisibleRadio.onclick = showMissingReasonAttributes
    var notLoadedIsVisibleRadio = radios[2];
    notLoadedIsVisibleRadio.onclick = hideMissingReasonAttributes
  },
  onDestroy: function() {
    // Задание завершено, можно освобождать (если были использованы) глобальные ресурсы
  }
});

function extend(ParentClass, constructorFunction, prototypeHash) {
  constructorFunction = constructorFunction || function () {};
  prototypeHash = prototypeHash || {};
  if (ParentClass) {
    constructorFunction.prototype = Object.create(ParentClass.prototype);
  }
  for (var i in prototypeHash) {
    constructorFunction.prototype[i] = prototypeHash[i];
  }
  return constructorFunction;
}
