exports.Task = extend(TolokaHandlebarsTask, function (options) {
  this._inputs = options.task.input_values;
  TolokaHandlebarsTask.call(this, options);
}, {
  validate: function (solution) {
    var output_values = solution.output_values;

    if (output_values.state == 'ok') {
      if (!output_values.house_number || output_values.house_number.length == 0) {
        return {
          task_id: this.getTask().id,
          errors: {
            state: {
              code: 'NOT_ALLOWED',
              message: 'Введите номер дома'
            }
          }
        }
      }
    } else {
      if (output_values.house_number && output_values.house_number.length > 0) {
        return {
          task_id: this.getTask().id,
          errors: {
            state: {
              code: 'NOT_ALLOWED',
              message: 'Номер дома должен быть пустым'
            }
          }
        }
      }
      this.setSolutionOutputValue("house_number", "")
    }

    if (this.getTask().input_values.golden_polygons) {
      var golden_polygons = this.getTask().input_values.golden_polygons;
      var user_polygons = output_values.polygons;
      var golden_polygons_count = golden_polygons.length;
      var user_polygons_count = user_polygons ? user_polygons.length : 0;
      var is_correct = true;
      if (golden_polygons_count != user_polygons_count) {
        is_correct = false;
      } else if (golden_polygons_count == 0 && user_polygons_count == 0) {
          is_correct = true;
      } else {
        for (var i = 0; i < golden_polygons_count; i++) {
          var is_found = false;
          for (var j = 0; j < user_polygons_count; j++) {
            is_found = iou(golden_polygons[i], user_polygons[j]) > 0.5;
            if (is_found) {
              break;
            }
          }
          if (!is_found) {
            is_correct = false;
            break;
          }
        }
      }
      this.setSolutionOutputValue("is_correct", is_correct)
    }

    return null;
  },
  onRender: function() {
    function draw(canvas, url, bbox) {
      var image = new Image();
      image.src = url
      image.addEventListener('load', function () {
        canvas[0].width = image.width;
        canvas[0].height = image.height;
        var context = canvas[0].getContext('2d');
        context.drawImage(image, 0, 0);

        var x1 = Math.min(bbox[0][0], bbox[1][0])
        var y1 = Math.min(bbox[0][1], bbox[1][1])
        var x2 = Math.max(bbox[0][0], bbox[1][0])
        var y2 = Math.max(bbox[0][1], bbox[1][1])

        var width = x2 - x1
        var height = y2 - y1

        var x_pad = Math.max(10, Math.round(width * 0.15))
        var y_pad = Math.max(10, Math.round(height * 0.15))
        x1 = Math.max(0, x1 - x_pad)
        y1 = Math.max(0, y1 - y_pad)
        x2 = Math.min(image.width, x2 + x_pad)
        y2 = Math.min(image.height, y2 + y_pad)

        width = x2 - x1
        height = y2 - y1

        context.beginPath();
        context.lineWidth = '2';
        context.strokeStyle= 'red';
        context.rect(x1, y1, width, height);
        context.closePath();
        context.stroke();

        context.beginPath();
        context.lineWidth = '2';
        context.strokeStyle= 'yellow';
        context.rect(x1 - 2, y1 - 2, width + 2 * 2, height + 2 * 2);
        context.closePath();
        context.stroke();
      });
    }

    var image = $(this.getDOMElement()).find('.image');
    var image_canvas = image[0].getElementsByTagName('canvas');
    draw(image_canvas, this._inputs.image, this._inputs.bbox);

    image[0].onclick = function () {
      if (image[0].className == "image") {
        image[0].className = "image image_zoom";
      } else {
        image[0].className = "image";
      }
    }
  }
});

function extend(ParentClass, constructorFunction, prototypeHash) {
  constructorFunction = constructorFunction || function () {};
  prototypeHash = prototypeHash || {};
  if (ParentClass) {
    constructorFunction.prototype = Object.create(ParentClass.prototype);
  }
  for (var i in prototypeHash) {
    constructorFunction.prototype[i] = prototypeHash[i];
  }
  return constructorFunction;
}
