import sys
import json
import operator

answers_stat = {}
id_stat = {}
ans_tuples = []
sign_tuples = []

for i in range(1, len(sys.argv)):
  fn = sys.argv[i]
  with open(fn) as f:
    data = json.loads(f.read())
    for item in data['classified_signs']:
        for sign in item['signs']:
            answer = sign['answer']
            id = sign['sign_id']
            answers_stat[answer] = answers_stat.get(answer, 0) + 1

            if answer == 'ok':
                id_stat[id] = id_stat.get(id, 0) + 1

for k,v in answers_stat.iteritems():
    ans_tuples.append((k,v))
ans_tuples.sort(key = operator.itemgetter(1), reverse=True)

for k,v in id_stat.iteritems():
    sign_tuples.append((k,v))
sign_tuples.sort(key = operator.itemgetter(0))
sign_tuples.sort(key = operator.itemgetter(1), reverse=True)

print '**Answers:**'
for item in ans_tuples:
    print item[0], '--', item[1]

print '**Sign types:**'
for item in sign_tuples:
    print item[0], '--', item[1]
