#pragma once

#include <yandex/maps/mrc/toloka_client/client.h>
#include "types.h"

namespace maps {
namespace mrc {
namespace toloka {

/**
 * Return merged task results for all finished tasks
 * of the given Toloka task suites
 */
std::vector<TaskSuiteResult> mergeTasksResults(
        const IdToTaskSuite& idToTaskSuite,
        const TaskSuiteIdToResults& idToTaskSuiteResults);

/**
 * Return merged task results for all finished tasks of all task suites
 * from the given Toloka pool id.
 */
std::vector<TaskSuiteResult>
loadAndMergeTasksResults(const io::TolokaClient& tolokaClient,
                         const std::string& poolId);

/**
 * Evaluate and accept/reject user assignments
 */
void evaluateAssignments(const io::TolokaClient& tolokaClient,
                         const TaskSuiteResult& tsResult,
                         bool dryRun);


/**
 * Write task results to ouputFile in json format
 * Example:
{
    "classified_signs": [
        {
            "source": "http://image-url.jpg",
            "signs": [
                {
                    "bbox": [[100,100],[200,200]],
                    "answer": "ok",
                    "sign_type": "sign_type_ru_2.4",
                },
                {
                    "bbox": [[600,600],[700,700]],
                    "answer": "not-recognized"
                },
                ...
            ]
        },
        ...
    ]
} */
void writeTaskResults(const std::vector<TaskSuiteResult>& taskResults,
                      const std::string& outputFile);

} // toloka
} // mrc
} // maps
