#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <yandex/maps/mrc/toloka_client/client.h>
#include <maps/libs/json/include/value.h>

#include <string>

namespace maps {
namespace mrc {
namespace toloka {

class ClassificationTasksGenerator
{
public:
    ClassificationTasksGenerator(const io::TolokaClient& tolokaClient,
                                 const std::string& poolId,
                                 const std::string& inputFilename)
            : tolokaClient_(tolokaClient)
            , poolId_(poolId)
            , input_(json::Value::fromFile(inputFilename))
    {
    }

    ClassificationTasksGenerator& setOverlap(size_t overlap)
    {
        overlap_ = overlap;
        return *this;
    }

    std::string generate(const std::string& startImageUrl,
                         size_t taskSuitesCount,
                         size_t tasksPerSuite);

private:
    const io::TolokaClient& tolokaClient_;
    std::string poolId_;
    json::Value input_;
    size_t overlap_;
};

} // toloka
} // mrc
} // maps
