#pragma once

#include <yandex/maps/mrc/toloka_client/client.h>
#include "types.h"

namespace maps {
namespace mrc {
namespace toloka {

/**
 * Return merged task results for all finished tasks
 * of the given Toloka task suites
 */
std::vector<TaskSuiteResult> mergeTasksResults(
        const IdToTaskSuite& idToTaskSuite,
        const TaskSuiteIdToResults& idToTaskSuiteResults);

/**
 * Return merged task results for all finished tasks of all task suites
 * from the given Toloka pool id.
 */
std::vector<TaskSuiteResult>
loadAndMergeTasksResults(const io::TolokaClient& tolokaClient,
                         const std::string& poolId);

/**
 * Evaluate and accept/reject user assignments
 */
void evaluateAssignments(const io::TolokaClient& tolokaClient,
                         const TaskSuiteResult& tsResult,
                         bool dryRun);


/**
 * Write task results to ouputFile in json format
 * Example:
 * {
 *     "detection_task_results": [
 *         {
 *             "source": "https://feature/1/image"
 *             "solutions": [
 *                 {
 *                     "bbox": [[110.0, 120.0], [230.0, 240.0]]
 *                 },
 *                 {
 *                     "bbox": [[420.0, 500.0], [480.0, 550.0]]
 *                 }
 *             ]
 *         },
 *         ...
 *     ]
 * }
 */
void writeTaskResults(const std::vector<TaskSuiteResult>& taskResults,
                      const std::string& outputFile);

} // toloka
} // mrc
} // maps
