#include "types.h"

#include <maps/libs/common/include/exception.h>

#include <ostream>

namespace maps {

namespace geolib3 {

std::ostream& operator<<(std::ostream& out, const BoundingBox& box)
{
    return out << "[[" << box.minX() << "," << box.minY() << "]"
               << ",[" << box.maxX() << "," << box.maxY() << "]]";
}

} // geolib3

namespace mrc {
namespace toloka {

std::ostream& operator<<(std::ostream& out, const TaskInput& taskInput)
{
    return out << "{source: " << taskInput.source << "}";
}

std::ostream& operator<<(std::ostream& out, const TaskOutput& taskOutput)
{
    return out << "{rectangles: " << taskOutput.rectangles << "}";
}

std::ostream& operator<<(std::ostream& out, const TaskResult& taskResult)
{
    return out << "{ input: " << taskResult.input
               << ", output: " << taskResult.output
               << " }";
}

std::ostream& operator<<(std::ostream& out, const TaskSuite& taskSuite)
{
    return out << "{ id: " << taskSuite.id
               << ", poolId: " << taskSuite.poolId
               << ", overlap: " << taskSuite.overlap
               << ", tasks: " << taskSuite.tasks
               << " }";
}

std::ostream& operator<<(std::ostream& out, const AssignmentResult& result)
{
    return out << "{ inputs: " << result.inputs
               << ", outputs: " << result.outputs
               << ", status: " << result.status
               << ", taskSuiteId: " << result.taskSuiteId
               << ", assignmentId: " << result.assignmentId
               << ", userId: " << result.userId
               << " }";

}
std::ostream& operator<<(std::ostream& out,
                         const TaskSuiteIdToResults& idToResults)
{
    out << "{ ";
    wiki::common::join(idToResults,
            [](const TaskSuiteIdToResults::value_type& pair) {
                std::ostringstream oss;
                oss << pair.first << " -> {" << pair.second << "}";
                return oss.str();
            }, ",");
    out << " }";
    return out;
}

std::ostream& operator<<(std::ostream& out, const UserStat& userStat)
{
    return out << "{ userId: " << userStat.uid
               << ", submitted signs: " << userStat.submittedSignsCount
               << ", truePositives: " << userStat.truePositives
               << " }";
}

} // toloka
} // mrc
} // maps
