#pragma once

#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <yandex/maps/mrc/toloka_client/client.h>
#include <pqxx>

namespace maps {
namespace mrc {
namespace toloka {

class DetectionTasksGenerator
{
public:
    DetectionTasksGenerator(
        pqxx::transaction_base& txn,
        const io::TolokaClient& tolokaClient,
        const std::string& poolId)
            : txn_(txn)
            , tolokaClient_(tolokaClient)
            , poolId_(poolId)
    {
    }

    db::TIds::iterator generate(
            db::TIds::iterator beg,
            db::TIds::iterator end,
            size_t taskSuitesCount,
            size_t overlap);

private:
    void postTaskSuite(db::Features::iterator beg,
                       db::Features::iterator end,
                       size_t overlap);

    pqxx::transaction_base& txn_;
    const io::TolokaClient& tolokaClient_;
    std::string poolId_;
};

} // toloka
} // mrc
} // maps
