#pragma once

#include <maps/libs/geolib/include/bounding_box.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <boost/geometry/geometries/box.hpp>
#include <boost/geometry/geometries/point_xy.hpp>
#include <boost/geometry/index/rtree.hpp>
#include <geos/geom/Geometry.h>

#include <pqxx/transaction_base>
#include <string>
#include <vector>
#include <utility>

namespace maps {
namespace mrc {
namespace toloka {

using Strings = std::vector<std::string>;

using GeomPtr = std::shared_ptr<geos::geom::Geometry>;

using Point = boost::geometry::model::d2::point_xy<double>;
using Box = boost::geometry::model::box<Point>;
using BoxAndGeomPair = std::pair<Box, GeomPtr>;
using BoxAndGeomPairs = std::vector<BoxAndGeomPair>;
using RTree
    = boost::geometry::index::rtree<BoxAndGeomPair,
                                    boost::geometry::index::quadratic<16>>;

// Returns collection of geometries in WKB
Strings loadYmapsdfGeometries(const std::string& toolConfigPath);

RTree makeRTree(const Strings& geomWkbs);

db::TIds loadAffectedFeatureIds(pqxx::transaction_base& txn,
                                const RTree& rTree);

} // toloka
} // mrc
} // maps
