#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/common/include/environment.h>
#include <maps/libs/common/include/exception.h>
#include <maps/libs/geolib/include/conversion.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/privacy/include/geo_id_provider.h>
#include <maps/wikimap/mapspro/services/mrc/tools/blur_mds/lib/process.h>

int main(int argc, char* argv[])
try {
    using namespace maps::mrc::blur_mds;

    auto parser = maps::cmdline::Parser{
        "Blurs photos in given region and updates them in MDS"};
    auto configPath = parser.string("config").help("file path");
    auto secretVersion = parser.string("secret").help("yav.yandex-team.ru");
    auto geoIdCoveragePath =
        parser.string("geoid-coverage").help("path to coverage5-geoid mms");
    auto geoId = parser.num("geoid").help("working region").required();
    auto dryRun = parser.flag("dry-run").help("do not save changes");
    parser.parse(argc, argv);
    INFO() << "start, dry-run=" << dryRun;

    auto config =
        maps::mrc::common::templateConfigFromCmdPath(secretVersion, configPath);
    switch (maps::common::getYandexEnvironment()) {
        case maps::common::Environment::Stable:
        case maps::common::Environment::Testing:
            INFO() << "Enable TVM suppport";
            config.enableTvmClient();
            break;
        default:
            break;
    }
    auto postgres = config.makePoolHolder();
    auto mds = config.makeMdsClient();
    auto geoIdProvider = maps::mrc::privacy::makeGeoIdProvider(
        geoIdCoveragePath.defined() ? std::string(geoIdCoveragePath)
                                    : config.externals().geoIdCoveragePath());
    auto geodeticGeom = geoIdProvider->geomById(geoId);
    auto mercatorGeom = maps::geolib3::convertGeodeticToMercator(geodeticGeom);
    maps::mrc::blur_mds::process(postgres.pool(), mds, mercatorGeom, dryRun);

    INFO() << "done";
    return EXIT_SUCCESS;
}
catch (const maps::Exception& e) {
    ERROR() << e;
    return EXIT_FAILURE;
}
catch (const std::exception& e) {
    ERROR() << e.what();
    return EXIT_FAILURE;
}
