#include "blur.h"

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/exif.h>
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/opencv.h>

namespace maps::mrc::blur_mds {
namespace {

void blurSignalqOverlay(cv::Mat& image)
{
    // area with timestamp and coordinates
    static const struct {
        double minX, minY, maxX, maxY;
    } RelativeBoxes[]{
        {0.0, 0.916, 0.146, 1.0},
        {0.896, 0.926, 1.0, 1.0},
    };

    for (const auto& relativeBox : RelativeBoxes) {
        common::ellipticalBlur(
            image,
            common::ImageBox{
                static_cast<size_t>(relativeBox.minX * image.cols),
                static_cast<size_t>(relativeBox.minY * image.rows),
                static_cast<size_t>(relativeBox.maxX * image.cols),
                static_cast<size_t>(relativeBox.maxY * image.rows)});
    }
}

}  // namespace

common::Blob blurImage(const common::Blob& imageBlob,
                       const db::Feature& feature,
                       const db::ObjectsInPhoto& objects)
{
    auto image = common::decodeImage(imageBlob);
    for (const auto& object : objects) {
        ASSERT(feature.id() == object.featureId());
        common::ellipticalBlur(image, object.imageBox());
    }
    if (feature.dataset() == db::Dataset::TaxiSignalQ2) {
        blurSignalqOverlay(image);
    }
    auto result = common::toBlob(common::encodeImage(image));
    auto exifData = common::getExifData(imageBlob);
    common::setExifData(result, exifData);
    return result;
}

}  // namespace maps::mrc::blur_mds
