#pragma once

#include "db.h"

#include <maps/libs/geolib/include/multipolygon.h>
#include <maps/libs/mds-client/include/yandex/maps/mds/mds.h>
#include <maps/libs/pgpool/include/pgpool3.h>

#include <span>

namespace maps::mrc::blur_mds {

void process(pgpool3::Pool&,
             mds::Mds&,
             const geolib3::MultiPolygon2& mercatorGeom,
             bool dryRun);

/// in header file for unit-test only
static const auto BlurredSuffix = std::string{"blurred"};

/// @return affected features
size_t updateFeatures(pgpool3::Pool&,
                      mds::Mds&,
                      std::span<db::Feature>,
                      const ObjectsByFeatureId&,
                      bool dryRun) noexcept;

}  // namespace maps::mrc::blur_mds
