#pragma once

#include "tools.h"

#include <maps/libs/json/include/value.h>
#include <maps/libs/nirvana/include/client.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>

namespace maps::mrc::tools {

class Context {
public:
    Context(common::Config& cfg, std::string nirvanaToken);

    Photos postToPublicMds(const db::TIds& featureIds);

    void runWorkflow(const std::string& workflow,
                     const std::string& inputJson,
                     const std::string& outputPath);

private:
    common::Config& cfg_;
    std::string nirvanaToken_;

    nirvana::OperationParameters
    postToPublicMds(const std::string& nirvanaWorkflow,
                    const std::string& inputJson);

    void deleteFromPublicMds(const Photos&);
};

} // maps::mrc::tools
