#include "context.h"
#include "tools.h"

#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/vault_boy/include/secrets.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>

#include <maps/libs/log8/include/log8.h>

namespace {

/**
 * @see
 * https://yav.yandex-team.ru/secret/sec-01cp2k8gbhycereqjrqg2va311/explore/versions
 */
const auto CONFIG_SECRET = "sec-01cp2k8gbhycereqjrqg2va311";

/**
 * @see
 * https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/services/mrc/libs/config/cfg/t-config.production.xml
 */
const auto CONFIG_PATH = "../../../libs/config/cfg/t-config.production.xml";

/**
 * @see
 * https://nirvana.yandex-team.ru/process/1fb10f93-380f-44e8-895c-bf8abfd9ebc2
 */
const auto WORKFLOW = "1fb10f93-380f-44e8-895c-bf8abfd9ebc2";

} // anonymous namespace

int main(int argc, const char** argv) try {
    maps::cmdline::Parser parser("Tool to collect traffic signs");
    auto inputPath = parser.string("input").required().help(
        "Input text file with feature IDs");
    auto outputPath = parser.string("output").required().help(
        "Output YT table with traffic signs");
    auto nirvanaToken = parser.string("nirvana-token")
                            .required()
                            .help("OAuth token for nirvana client");
    parser.parse(argc, const_cast<char**>(argv));
    auto cfg = maps::mrc::common::Config(
        maps::vault_boy::loadContextWithYaVault(CONFIG_SECRET), CONFIG_PATH);
    maps::mrc::tools::Context ctx{cfg, nirvanaToken};
    auto ids = maps::mrc::tools::loadIds(inputPath);
    auto photos = ctx.postToPublicMds(ids);
    auto inputJson = toInputJson(photos);
    ctx.runWorkflow(WORKFLOW, inputJson, outputPath);
    return EXIT_SUCCESS;
}
catch (const maps::Exception& e) {
    INFO() << e;
    return EXIT_FAILURE;
}
catch (const std::exception& e) {
    INFO() << e.what();
    return EXIT_FAILURE;
}
