#include "tools.h"

#include <maps/libs/json/include/builder.h>
#include <maps/libs/log8/include/log8.h>

#include <fstream>
#include <set>

namespace maps::mrc::tools {

db::TIds loadIds(const std::string& inputPath)
{
    INFO() << inputPath;
    std::set<db::TId> result;
    std::ifstream file(inputPath, std::ios_base::in);
    for (std::string line; std::getline(file, line);) {
        result.insert(std::atoll(line.c_str()));
    }
    INFO() << "Loaded: " << result.size() << " IDs";
    return {result.begin(), result.end()};
}

std::string toInputJson(const Photos& photos)
{
    json::Builder builder;
    builder << [&](json::ArrayBuilder b) {
        for (const auto& photo : photos) {
            b << [&](json::ObjectBuilder b) {
                b["inputValues"] <<
                    [&](json::ObjectBuilder b) { b["source"] = photo.url; };
            };
        }
    };
    return builder.str();
}

} // maps::mrc::tools
