#include "tools.h"

#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/common/include/exception.h>
#include <maps/libs/log8/include/log8.h>

#include <fstream>

int main(int argc, const char** argv) try {
    maps::cmdline::Parser parser("Merge Toloka results from multiple users");
    auto inputPath = parser.string("input").required().help(
        "input JSON with Toloka assignments");
    auto outputPath = parser.string("output").required().help(
        "output JSON with traffic signs");
    parser.parse(argc, const_cast<char**>(argv));
    INFO() << "Start Toloka results merging";
    std::ifstream is(inputPath);
    auto assignments = maps::json::Value::fromStream(is);
    auto urlToBase64DataMap = maps::mrc::tools::loadPhotos(assignments);
    auto urlToSignsMap = maps::mrc::tools::aggregateSigns(assignments);
    std::ofstream os(outputPath);
    maps::mrc::tools::dump(urlToBase64DataMap, urlToSignsMap, os);
    INFO() << "Finish Toloka results merging";
}
catch (const maps::Exception& e) {
    INFO() << e;
    return EXIT_FAILURE;
}
catch (const std::exception& e) {
    INFO() << e.what();
    return EXIT_FAILURE;
}
