#include "tool.h"

#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/libs/vault_boy/include/secrets.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/libs/common/include/exception.h>

namespace {

/**
 * @see
 * https://yav.yandex-team.ru/secret/sec-01cp2k8gbhycereqjrqg2va311/explore/versions
 */
const auto CONFIG_SECRET = "sec-01cp2k8gbhycereqjrqg2va311";

/**
 * @see
 * https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/services/mrc/libs/config/cfg/t-config.production.xml
 */
const auto CONFIG_PATH = "../../libs/config/cfg/t-config.production.xml";

}  // anonymous namespace

int main(int argc, char* argv[])
try {
    maps::cmdline::Parser parser;
    auto ytTable = parser.string("yt_table")
                       .required()
                       .help(
                           "table in "
                           "https://yt.yandex-team.ru/hahn/navigation"
                           "?path=//home/maps/core/garden/stable/ymapsdf");
    auto adId = parser.size_t("ad_id").required().help(
        "ID of the unit of administrative division");
    auto outDir = parser.string("out_dir").required().help("output directory");
    auto sessionId =
        parser.string("session_id").required().help("COOKIE Session_id");
    auto sessionId2 =
        parser.string("session_id_2").required().help("COOKIE sessionid2");
    parser.parse(argc, argv);
    auto cfg = maps::mrc::common::Config(
        maps::vault_boy::loadContextWithYaVault(CONFIG_SECRET), CONFIG_PATH);
    maps::mrc::run(cfg, ytTable, adId, outDir, sessionId, sessionId2);
    return EXIT_SUCCESS;
}
catch (const maps::Exception& e) {
    ERROR() << e;
    return EXIT_FAILURE;
}
catch (const std::exception& e) {
    ERROR() << e.what();
    return EXIT_FAILURE;
}
