#pragma once

#include "types.h"

namespace maps::mrc::tracks_with_sensors {

// how to match calculated and gt signs
enum class SignMatching {
    Nearest,
    ById
};

struct Accuracy {
    double avgError;
    std::vector<double> sortedErrors;
    double recall;
    double deviation; // standard deviation
    int severalSignsForOneGt; // if several signs matched with one gt sign
};

Accuracy compareWithGroundTruth(const Signs& signs,
                                const Signs& gtSigns,
                                SignMatching signMatching);

void printAccuracy(const Accuracy& accuracy);


} // namespace maps::mrc::tracks_with_sensors
