#pragma once

#include "types.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/track_point.h>

namespace maps::mrc::tracks_with_sensors {

db::TrackPoints loadTrack(const std::string& datasetPrefix);

SensorEvents loadSensors(const std::string& datasetPrefix);

// Loads photos and rotates image data using feature orientation
Photos loadPhotos(const std::string& datasetPrefix,
                  std::optional<chrono::TimePoint> minTime = std::nullopt,
                  std::optional<chrono::TimePoint> maxTime = std::nullopt);

// Loads signs bboxes and rotates them using feature orientation
SignPhotos loadSigns(
    const std::string& datasetPrefix,
    const std::optional<std::unordered_set<db::TId>>& featureIds = std::nullopt);

std::vector<Sign> loadGtSigns(
    const std::string& datasetPrefix,
    const std::optional<std::unordered_set<SignGtId>>& signGtIds = std::nullopt);

} // namespace maps::mrc::tracks_with_sensors
