#pragma once

#include "types.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/track_point_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/sign_gateway.h>

namespace maps::mrc::tracks_with_sensors {

db::TrackPoints loadTrack(
    wiki::common::PoolHolder& poolHolder,
    db::TId assignmentId,
    std::string sourceId);

Photos loadPhotos(
    wiki::common::PoolHolder& poolHolder,
    db::TId assignmentId,
    std::string sourceId,
    chrono::TimePoint minTime,
    chrono::TimePoint maxTime);

SignPhotos loadSignBboxes(
    wiki::common::PoolHolder& poolHolder,
    const Photos& photos);

db::Signs loadSigns(
    wiki::common::PoolHolder& poolHolder,
    const geolib3::BoundingBox& mercatorBbox);

db::Features loadFeaturesOfSign(
    wiki::common::PoolHolder& poolHolder,
    db::TId signId);

} // namespace maps::mrc::tracks_with_sensors
