#pragma once

#include "types.h"

#include <maps/libs/geolib/include/polyline.h>

#include <string>
#include <vector>

namespace maps::mrc::tracks_with_sensors {

struct Properties {
    std::string description;
    std::string color;
    double width;
};

// Creates geojson file and draws some objects.
// This file can be open in https://yandex.ru/map-constructor/
class GeojsonSaver {
public:
    // draw signs as a short segments
    // [cameraPos, cameraPos + fromCameraToSignDirection * 80m]
    void addSignsAsRays(const sensors_feature_positioner::Rays& signRays);

    // draw several sign. Each sign is represented as a group of
    // probable sign positions. See addSignGroupsAsPolylines method
    void addSignGroupsAsPolylines(const std::vector<Signs>& signGroups);

    void addSignsAsPoints(const Signs& signs,
                          const std::string& tag,
                          const std::string& color = "#00ff00");
    // draw a photo as a short segment
    // [cameraPos, cameraPos + cameraDirection * 80m]
    void addPhotoAsRay(const pos_improvment::ImprovedGpsEvent& pos);

    // writes all the drawings to the file
    void save(const std::string& filename);

private:
    // draw a sign as a short segment
    // [cameraPos, cameraPos + fromCameraToSignDirection * 10m]
    void addSignAsRay(const sensors_feature_positioner::Ray& signRay);

    // Draw one sign where sign is represented as a group of probable
    // sign positions
    // (draw a polyline that connects all the probable sign coordinates)
    void addSignGroupAsPolyline(const Signs& signGroup, Properties properties);

    std::vector<std::pair<Properties, geolib3::Polyline2>> polylines_;
};

} // namespace maps::mrc::tracks_with_sensors
