#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/position_improvment/include/position_improvment.h>
#include <maps/wikimap/mapspro/services/mrc/libs/sensors_feature_positioner/include/sensors_loader.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/track_point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/sign.h>
#include <maps/libs/geolib/include/direction.h>

#include <vector>

namespace maps::mrc::tracks_with_sensors {

using SensorEvents = sensors_feature_positioner::SensorEvents;

struct Track {
    db::TrackPoints trackPoints;
    SensorEvents sensorEvents;
};
using Tracks = std::vector<Track>;

struct Photo {
    db::TId featureId;
    chrono::TimePoint timestamp;
    geolib3::Point2 mercatorPos; // from db
    geolib3::Heading heading; // from db
    common::Size size;
    common::ImageOrientation orientation;
};
using Photos = std::vector<Photo>;

using SignGtId = int;

struct SignPhoto {
    db::TId featureId;
    chrono::TimePoint featureTs;
    common::Size photoSize;
    traffic_signs::TrafficSign signType;
    common::ImageBox bbox;
    std::optional<SignGtId> signGtId;
};
using SignPhotos = std::vector<SignPhoto>;

struct Sign {
    geolib3::Point2 mercatorPos;
    traffic_signs::TrafficSign signType;
    geolib3::Heading heading;
    std::optional<int> id = std::nullopt;
};
using Signs = std::vector<Sign>;

} // namespace maps::mrc::tracks_with_sensors
