#include "photos.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>
#include <maps/libs/log8/include/log8.h>

#include <vector>

namespace maps::mrc::tracks_with_sensors {

db::Features loadPhotos(
    wiki::common::PoolHolder& poolHolder,
    db::TId assignmentId,
    chrono::TimePoint minTime,
    chrono::TimePoint maxTime,
    std::string sourceId)
{
    auto txn = poolHolder.pool().slaveTransaction();
    db::FeatureGateway photoGtw(*txn);

    db::Features photos = photoGtw.load(
        db::table::Feature::assignmentId.equals(assignmentId)
        && db::table::Feature::sourceId.equals(sourceId)
        && db::table::Feature::date >= minTime
        && db::table::Feature::date <= maxTime);
    INFO() << "loaded " << photos.size() << "assignmentPhotos";

    std::sort(photos.begin(), photos.end(),
              [](const db::Feature& lhs, const db::Feature& rhs) {
                  return lhs.timestamp() < rhs.timestamp();
              });

    db::Features filteredPhotos;
    filteredPhotos.reserve(photos.size());

    for (auto photo : photos) {
        if (!filteredPhotos.empty() &&
            photo.timestamp() == filteredPhotos.back().timestamp())
        {
            WARN() << "2 photos with equal timestamp";
            continue;
        }
        filteredPhotos.push_back(photo);
    }

    INFO() << "loaded " << filteredPhotos.size() << "filteredPhotos";
    return filteredPhotos;
}

} // namespace maps::mrc::tracks_with_sensors
