#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/position_improvment/include/position_improvment.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/track_point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/sign.h>
#include <maps/libs/geolib/include/direction.h>

#include <vector>

namespace maps::mrc::tracks_with_sensors {

struct SensorEvents {
    pos_improvment::GyroscopeEvents gyroEvents;
    pos_improvment::AccelerometerEvents accEvents;
};

struct Track {
    db::TrackPoints trackPoints;
    SensorEvents sensorEvents;
};
using Tracks = std::vector<Track>;

struct Photo {
    db::Feature feature;
    pos_improvment::ImprovedGpsEvent cameraPos;
};
using Photos = std::vector<Photo>;

using SignGtId = int;

struct SignPhoto {
    traffic_signs::TrafficSign signType;
    pos_improvment::ImprovedGpsEvent cameraPos;
    pos_improvment::UnitVector3 directionToSign;
    double metersToSign;
    db::Feature feature;
    db::Sign sign;
    SignGtId idFromDataset = -1;
};
using SignPhotos = std::vector<SignPhoto>;

struct SignIntersection {
    geolib3::Point3 odoMercatorPos;
    double errorMeters;
    double distanceFromCamera1;
    double distanceFromCamera2;
    geolib3::Radians errorRadians = geolib3::Radians(0); // max angle between the camera
                                                         // direction and the vector from
                                                         // the camera to the sign position
};

struct Sign {
    geolib3::Point2 mercatorPos;
    double heighMeters;
    traffic_signs::TrafficSign signType;
    geolib3::Radians angleBetweenCameras = geolib3::Radians(0);
    std::vector<SignGtId> idsFromDataset = {};
};
using Signs = std::vector<Sign>;
using SignGroup = std::vector<Sign>;
using SignGroups = std::vector<SignGroup>;
using GtSigns = std::unordered_map<SignGtId, Sign>;



} // namespace maps::mrc::tracks_with_sensors
