#include "sign.h"

#include <yandex/maps/mrc/traffic_signs/signs.h>
#include <maps/libs/geolib/include/conversion.h>
#include <maps/libs/geolib/include/heading.h>
#include <maps/libs/geolib/include/units.h>
#include <maps/libs/geolib/include/serialization.h>

namespace maps {
namespace mrc {
namespace export_hypotheses {

db::Sign createSign(const json::Value& sign)
{
    constexpr geolib3::Degrees DEFAULT_HEADING_VARIANCE_DEGREES(45.0);
    constexpr double DEFAULT_POSITION_VARIANCE_METERS(15.0);

    const geolib3::Point2 position = geolib3::geoPoint2Mercator(
        geolib3::readGeojson<geolib3::Point2>(sign["geometry"])
    );

    return sql_chemistry::GatewayAccess<db::Sign>::construct()
                .setType(traffic_signs::stringToTrafficSign(sign["type"].as<std::string>()))
                .setHeading(
                    geolib3::normalize(geolib3::Heading(sign["heading"].as<double>())),
                    DEFAULT_HEADING_VARIANCE_DEGREES
                )
                .setMercatorPos(
                    position,
                    DEFAULT_POSITION_VARIANCE_METERS
                );
}

db::SignFeatures createSignFeatures(const json::Value& features)
{
    db::SignFeatures signFeatures;
    signFeatures.reserve(features.size());
    for (const auto& feature: features) {
        const auto& box = feature["box"];

        signFeatures.emplace_back(
            std::stoull(feature["id"].as<std::string>()),
            box[0].as<double>(),
            box[1].as<double>(),
            box[2].as<double>(),
            box[3].as<double>()
        );
    }

    return signFeatures;
}

} //namespace export_hypotheses
} //namespace mrc
} //namespace maps
