#include <maps/wikimap/mapspro/services/mrc/tools/export_hypotheses/lib/hypothesis.h>

#include <library/cpp/testing/common/env.h>
#include <library/cpp/testing/gtest/gtest.h>
#include <maps/libs/ymapsdf/include/ft.h>
#include <maps/libs/geolib/include/conversion.h>

#include <string>

namespace maps {
namespace mrc {
namespace export_hypotheses {
namespace tests {

using FtType = ymapsdf::ft::Type;

const std::string SOURCE_CONTEXT_PATH(
    ArcadiaSourceRoot() + "/maps/wikimap/mapspro/services/mrc/tools/export_hypotheses/tests/source_context.json"
);

TEST(test_hypothesis, test_create_hypothesis)
{
    const json::Value json = json::Value::fromFile(SOURCE_CONTEXT_PATH);

    const db::TId signId = 1;
    const db::TId feedbackTaskId = 1;

    const db::TId commitId = 64426969;
    const db::TId objectId = 2102268681;

    const db::Hypothesis hypothesis = createHypothesis(json, signId, feedbackTaskId);

    const geolib3::Point2 geoPosition(60.5811934488936, 56.832965249464415);
    const geolib3::Point2 mercatorPosition = geolib3::geoPoint2Mercator(geoPosition);

    EXPECT_EQ(hypothesis.signId(), signId);

    EXPECT_EQ(hypothesis.commitId(), commitId);
    EXPECT_EQ(hypothesis.objectId(), objectId);

    EXPECT_EQ(hypothesis.feedbackTaskId(), feedbackTaskId);

    EXPECT_EQ(hypothesis.type(), db::HypothesisType::WrongParkingFtType);
    EXPECT_EQ(hypothesis.mercatorPos(), mercatorPosition);

    const auto& context = hypothesis.context();

    EXPECT_TRUE(
        context.isObject()
        && context.fields().size() == 2
        && static_cast<FtType>(context["correctFtType"].as<int>()) == FtType::UrbanRoadnetParkingProhibited
        && static_cast<FtType>(context["currentFtType"].as<int>()) == FtType::UrbanRoadnetParkingFree
    );
}

} //namespace tests
} //namespace export_hypotheses
} //namespace mrc
} //namespace maps
