#include <maps/wikimap/mapspro/services/mrc/tools/export_hypotheses/lib/sign.h>

#include <library/cpp/testing/common/env.h>
#include <library/cpp/testing/gtest/gtest.h>
#include <maps/libs/geolib/include/conversion.h>

#include <algorithm>
#include <string>

namespace maps {
namespace mrc {
namespace export_hypotheses {
namespace tests {

const std::string SOURCE_CONTEXT_PATH(
    ArcadiaSourceRoot() + "/maps/wikimap/mapspro/services/mrc/tools/export_hypotheses/tests/source_context.json"
);

TEST(test_sign, test_create_sign)
{
    const json::Value json = json::Value::fromFile(SOURCE_CONTEXT_PATH);
    const db::Sign sign = createSign(json["sign"]);

    const geolib3::Point2 geoPosition(60.5811934488936, 56.832965249464415);
    const geolib3::Point2 mercatorPosition = geolib3::geoPoint2Mercator(geoPosition);

    EXPECT_EQ(sign.heading().value(), 337.75);
    EXPECT_EQ(sign.type(), db::Sign::Type::ProhibitoryNoParkingOrStopping);
    EXPECT_EQ(sign.mercatorPos(), mercatorPosition);
}

TEST(test_sign, test_create_sign_features)
{
    const json::Value json = json::Value::fromFile(SOURCE_CONTEXT_PATH);
    const db::SignFeatures signFeatures = createSignFeatures(json["features"]);

    EXPECT_EQ(signFeatures.size(), 2ul);

    const db::SignFeature one {
        9455313,
        /* box = */ 1561, 252, 1653, 344
    };

    const db::SignFeature two {
        9458082,
        /* box = */ 1347, 374, 1403, 430
    };

    for (const auto& box: {one, two}) {
        EXPECT_EQ(
            std::count(signFeatures.begin(), signFeatures.end(), box),
            1u
        );
    }
}

} //namespace tests
} //namespace export_hypotheses
} //namespace mrc
} //namespace maps
