#pragma once

#include "graph.h"

#include <yandex/maps/mds/mds.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/libs/sql_chemistry/include/filter.h>

namespace maps {
namespace mrc {
namespace features_deleter {

/// @brief wrapper for all configurable resources
class Context {
public:
    Context(const common::Config& cfg, const std::string& graphFolder);

    pgpool3::TransactionHandle masterReadOnlyTransaction();
    pgpool3::Pool& pool();

    db::TIds loadFeaturesIds();

    db::Features loadFeaturesByIds(const db::TIds&);

    db::Features loadFeatures(const sql_chemistry::Filter&);

    void unpublishFeatures(db::Features& features);

    void saveMetadata(size_t deletedCount);

    Graph& graph();

private:
    wiki::common::PoolHolder poolHolder_;
    mds::Mds mds_;
    Graph graph_;
};

} // features_deleter
} // mrc
} // maps
