#pragma once

#include <maps/libs/geolib/include/bounding_box.h>
#include <maps/libs/geolib/include/polyline.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <yandex/maps/program_options/option_description.h>

#include <memory>
#include <string>
#include <vector>

namespace maps {
namespace graph2 {

/**
 * workaround to avoid multiple definition
 * @see
 * https://a.yandex-team.ru/arc/trunk/arcadia/maps/libs/graph/po_helpers/impl/graph_paths-impl.h
 */
class GraphObjects;

} // graph2

namespace mrc {
namespace features_deleter {

// edge in the road graph
struct Edge {
    db::TId edgeId;
    geolib3::Polyline2 geom;
};

using Edges = std::vector<Edge>;

class Graph {
public:
    explicit Graph(const std::string& graphFolder);

    ~Graph();

    Edges edgesInWindow(const geolib3::BoundingBox& bbox);

    Edge edgeById(db::TId edgeId);

private:
    program_options::options_description optionsDescr_;
    std::unique_ptr<graph2::GraphObjects> graphObjects_;
};

} // features_deleter
} // mrc
} // maps
