#include "remove_features.h"
#include "tools.h"

#include <maps/libs/common/include/exception.h>
#include <maps/libs/common/include/make_batches.h>
#include <maps/libs/log8/include/log8.h>

#include <pqxx/pqxx>

namespace maps {
namespace mrc {
namespace features_deleter {

size_t unpublishFeaturesByIds(Context& ctx, const std::set<db::TId>& featureIds)
{
    static constexpr size_t BATCH_SIZE{4000};
    size_t unpublishedFeatures{0};
    for (const auto& batch :
         maps::common::makeBatches(featureIds, BATCH_SIZE)) {
        auto features = ctx.loadFeaturesByIds({batch.begin(), batch.end()});
        ctx.unpublishFeatures(features);
        unpublishedFeatures += features.size();
        INFO() << "Unpublished features: " << unpublishedFeatures;
    }
    return unpublishedFeatures;
}

} // features_deleter
} // mrc
} // maps
