#pragma once

#include <boost/range/adaptor/map.hpp>
#include <boost/range/algorithm/copy.hpp>

#include <iterator>
#include <set>

namespace ba = boost::adaptors;

namespace maps {
namespace mrc {
namespace features_deleter {

template <typename Map>
auto mapKeys(const Map& map)
{
    std::set<typename Map::key_type> result;
    boost::copy(map | ba::map_keys, std::inserter(result, result.end()));
    return result;
}

template <typename Map>
auto mapValues(const Map& map)
{
    std::set<typename Map::mapped_type> result;
    boost::copy(map | ba::map_values, std::inserter(result, result.end()));
    return result;
}

} // features_deleter
} // mrc
} // maps
