#!/bin/bash

SOURCE_ID="40c64514f9288e0e44f3ed41576585b0"
START_TIME="2020-03-23T00:00:00"
END_TIME="2020-03-23T23:59:59"
PEDESTRIAN_GRAPH="/home/naplavkov/temp/pedestrian_graph"
ROAD_GRAPH="/home/naplavkov/temp/road_graph"
PEDESTRIAN_JSON="./$(date +%FT%T)_pedestrian.json"
ROAD_JSON="./$(date +%FT%T)_road.json"
LOG="./$(date +%FT%T).log"

start=$SECONDS

./graph_selector \
 --source-id=$SOURCE_ID \
 --start-time=$START_TIME \
 --end-time=$END_TIME \
 --pedestrian-graph=$PEDESTRIAN_GRAPH \
 --road-graph=$ROAD_GRAPH \
 --pedestrian-json=$PEDESTRIAN_JSON \
 --road-json=$ROAD_JSON \
 --dry-run \
 1>>$LOG \
 2>>$LOG

echo $(( SECONDS - start )) >> $LOG
