#include "tool.h"

#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/libs/vault_boy/include/secrets.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/libs/common/include/exception.h>

namespace {

/**
 * @see
 * https://yav.yandex-team.ru/secret/sec-01cp2k8gbhycereqjrqg2va311/explore/versions
 */
const auto CONFIG_SECRET = "sec-01cp2k8gbhycereqjrqg2va311";

/**
 * @see
 * https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/services/mrc/libs/config/cfg/t-config.production.xml
 */
const auto CONFIG_PATH = "../../libs/config/cfg/t-config.production.xml";

}  // anonymous namespace

int main(int argc, char* argv[])
try {
    maps::cmdline::Parser parser;
    auto sourceId = parser.string("source-id").required().help("source ID");
    auto startTime =
        parser.string("start-time").required().help("taken at after");
    auto endTime = parser.string("end-time").required().help("taken at before");
    auto pedestrianGraph = parser.dir("pedestrian-graph")
                               .required()
                               .help("pedestrian graph directory");
    auto roadGraph =
        parser.dir("road-graph").required().help("road graph directory");
    auto pedestrianJson =
        parser.file("pedestrian-json").help("output pedestrian JSON file");
    auto roadJson = parser.file("road-json").help("output road JSON file");
    auto dryRun = parser.flag("dry-run")
                      .help("do not save changes to database")
                      .defaultValue(false);
    parser.parse(argc, argv);
    auto cfg = maps::mrc::common::Config(
        maps::vault_boy::loadContextWithYaVault(CONFIG_SECRET), CONFIG_PATH);
    maps::mrc::run(cfg,
                   sourceId,
                   maps::chrono::parseIsoDateTime(startTime),
                   maps::chrono::parseIsoDateTime(endTime),
                   pedestrianGraph,
                   roadGraph,
                   pedestrianJson,
                   roadJson,
                   dryRun);
    return EXIT_SUCCESS;
}
catch (const maps::Exception& e) {
    ERROR() << e;
    return EXIT_FAILURE;
}
catch (const std::exception& e) {
    ERROR() << e.what();
    return EXIT_FAILURE;
}
