#include "tools.h"

#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/vault_boy/include/secrets.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/libs/log8/include/log8.h>

namespace {

/**
 * @see
 * https://yav.yandex-team.ru/secret/sec-01cp2k8gbhycereqjrqg2va311/explore/versions
 */
const auto CONFIG_SECRET = "sec-01cp2k8gbhycereqjrqg2va311";

/**
 * @see
 * https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/services/mrc/libs/config/cfg/t-config.production.xml
 */
const auto CONFIG_PATH = "../../../libs/config/cfg/t-config.production.xml";

/**
 * @see
 * https://nirvana.yandex-team.ru/process/eb9fddab-9d10-44dd-8f2c-6815afc4f3b4
 */
const auto WORKFLOW = "eb9fddab-9d10-44dd-8f2c-6815afc4f3b4";

} // anonymous namespace

int main(int argc, const char** argv) try {
    namespace tools = maps::mrc::tools;
    maps::cmdline::Parser parser("Tool to collect house numbers");
    auto inputPath
        = parser.string("input").required().help("Input text file with URLs");
    auto outputPath = parser.string("output").required().help(
        "Output YT table with house numbers");
    auto nirvanaToken = parser.string("nirvana-token")
                            .required()
                            .help("OAuth token for nirvana client");
    parser.parse(argc, const_cast<char**>(argv));
    auto cfg = maps::mrc::common::Config(
        maps::vault_boy::loadContextWithYaVault(CONFIG_SECRET), CONFIG_PATH);
    auto publicMds = cfg.makePublicMdsClient();

    auto urls = tools::readUrls(inputPath);
    urls = tools::repostToMds(urls, publicMds);
    auto inputJson = tools::toInputJson(urls);
    auto inputUrl = tools::postToMds(inputJson, publicMds);
    tools::runWorkflow(nirvanaToken, WORKFLOW, inputUrl, outputPath);
    return EXIT_SUCCESS;
} catch (const maps::Exception& e) {
    INFO() << e;
    return EXIT_FAILURE;
} catch (const std::exception& e) {
    INFO() << e.what();
    return EXIT_FAILURE;
}
