#pragma once

#include <yandex/maps/mds/mds.h>

#include <set>
#include <string>

namespace maps::mrc::tools {

using URL = std::string;
using URLs = std::set<URL>;

URLs readUrls(const std::string& inputPath);
URL postToMds(const std::string& data, mds::Mds& publicMds);
URLs repostToMds(const URLs& urls, mds::Mds& publicMds);
std::string toInputJson(const URLs&);

void runWorkflow(const std::string& nirvanaToken,
    const std::string& workflow,
    const std::string& inputJson,
    const std::string& outputPath);

} // maps::mrc::tools
