#pragma once

#include <util/generic/string.h>
#include <util/system/datetime.h>
#include <util/random/random.h>

namespace maps::mrc::house_number_pipeline {

static const TString COLUMN_NAME_FEATURE_ID = "feature_id";
static const TString COLUMN_NAME_IMAGE      = "image";
static const TString COLUMN_NAME_LAT        = "lat";
static const TString COLUMN_NAME_LON        = "lon";
static const TString COLUMN_NAME_OBJECTS    = "objects";
static const TString COLUMN_NAME_ADDR_POINTS = "addr_points";
static const TString COLUMN_NAME_HYPOTHESES = "hypotheses";
static const TString COLUMN_NAME_DETECTED   = "detected";

static const TString ITEM_NAME_ADDR_NUMBER     = "addr_number";
static const TString ITEM_NAME_ADDR_PT_LAT     = "addr_pt_lat";
static const TString ITEM_NAME_ADDR_PT_LON     = "addr_pt_lon";
static const TString ITEM_NAME_VISIBLE_NUMBER  = "visible_number";

static const TString ITEM_NAME_ADDR_PT_X     = "addr_pt_x";
static const TString ITEM_NAME_ADDR_PT_Y     = "addr_pt_y";

static const TString ITEM_NAME_BBOX         = "bbox";
static const TString ITEM_NAME_NUM          = "num";
static const TString ITEM_NAME_CONFIDENCE   = "confidence";
static const TString ITEM_NAME_CONFIDENCE_DETECTOR   = "confidence_detector";
static const TString ITEM_NAME_CONFIDENCE_RECOGNIZER = "confidence_recognizer";

// Detector statistic
static const TString COLUMN_NAME_TRUE_POSITIVES  = "true_positives";
static const TString COLUMN_NAME_FALSE_POSITIVES = "false_positives";
static const TString COLUMN_NAME_FALSE_NEGATIVES = "false_negatives";

static const TString YT_TEMPORARY_FOLDER = "//tmp/maps_mrc";

constexpr std::chrono::milliseconds THREAD_WAIT_TIMEOUT(1);
} //namespace maps::mrc::house_number_pipeline

